/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.fabric;

import java.text.MessageFormat;
import mirsario.cameraoverhaul.common.CameraOverhaul;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;

public final class VersionUtils {
    public static final ModMetadata MinecraftMetadata = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get()).getMetadata();
    public static final Version MinecraftVersion = MinecraftMetadata.getVersion();

    public static boolean MinecraftVersionMatches(String versionExpression) {
        return VersionUtils.Matches(MinecraftVersion, versionExpression);
    }

    public static boolean Matches(Version version, String versionExpression) {
        if (!(version instanceof SemanticVersion)) {
            CameraOverhaul.Logger.error("Unknown minecraft version type!");
            return false;
        }
        try {
            return VersionPredicate.parse((String)versionExpression).test((Object)version);
        }
        catch (VersionParsingException e) {
            CameraOverhaul.Logger.error(MessageFormat.format("Error parsing version expression '{0}': {1}", versionExpression, e.getMessage()));
            return false;
        }
    }
}

